% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svmpred.R
\name{svmpred}
\alias{svmpred}
\title{Generate spatial predictions using support vector machine ('svm')}
\usage{
svmpred(
  formula = NULL,
  trainxy,
  longlatpredx,
  predx,
  scale = TRUE,
  type = NULL,
  kernel = "radial",
  degree = 3,
  gamma = if (is.vector(trainxy)) 1 else 1/ncol(trainxy),
  coef0 = 0,
  cost = 1,
  nu = 0.5,
  tolerance = 0.001,
  epsilon = 0.1,
  ...
)
}
\arguments{
\item{formula}{a formula defining the response variable and predictive variables.}

\item{trainxy}{a dataframe contains predictive variables and the response
variable of point samples. The location information, longitude (long),
latitude (lat), need to be included in the 'trainx' for spatial predictive
 modeling, need to be named as 'long' and 'lat'.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point
locations (i.e., the centers of grids) to be predicted, need to be named as
 'long' and 'lat'.}

\item{predx}{a dataframe or matrix contains columns of predictive variables
for the grids to be predicted.}

\item{scale}{A logical vector indicating the variables to be scaled (default: TRUE).}

\item{type}{the default setting is 'NULL'. See '?svm' for various options.}

\item{kernel}{the default setting is 'radial'. See '?svm' for other options.}

\item{degree}{a parameter needed for kernel of type polynomial (default: 3).}

\item{gamma}{a parameter needed for all 'kernels' except 'linear'
(default: 1/(data dimension)).}

\item{coef0}{a parameter needed for kernels of type 'polynomial' and 'sigmoid'(default: 0).}

\item{cost}{cost of constraints violation (default: 1).}

\item{nu}{a parameter needed for 'nu-classification', 'nu-regression', and 'one-classification' (default: 0.5).}

\item{tolerance}{tolerance of termination criterion (default: 0.001).}

\item{epsilon}{'epsilon' in the insensitive-loss function (default: 0.1).
See '?svm' for details.}

\item{...}{other arguments passed on to 'svm'.}
}
\value{
A dataframe of longitude, latitude and predictions.
}
\description{
This function is for generating spatial predictions using 'svm' method
in 'e1071' package.
}
\examples{
\donttest{
library(spm)
data(petrel)
data(petrel.grid)

gravel <- petrel[, c(1, 2, 6:9, 5)]
model <- log(gravel + 1) ~  lat +  bathy + I(long^3) + I(lat^2) + I(lat^3)

svmpred1 <- svmpred(formula = model, trainxy = gravel,
longlatpredx = petrel.grid[, c(1:2)], predx = petrel.grid)

names(svmpred1)

# Back transform 'svmpred1$pred.svm1' to generate the final predictions
svm.predictions <- exp(svmpred1$pred.svm1) - 1
range(svm.predictions)
}

}
\references{
David Meyer, Evgenia Dimitriadou, Kurt Hornik, Andreas Weingessel and Friedrich
Leisch (2020). e1071: Misc Functions of the Department of Statistics, Probability
Theory Group (Formerly: E1071), TU Wien. R package version 1.7-4.
https://CRAN.R-project.org/package=e1071.
}
\author{
Jin Li
}
