% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_list_elements.R
\name{is_all_list_elements_null_or_fully_named_list}
\alias{is_all_list_elements_null_or_fully_named_list}
\title{Are all elements in a list null or fully named lists?}
\usage{
is_all_list_elements_null_or_fully_named_list(x)
}
\arguments{
\item{x}{An object}
}
\value{
Boolean.
}
\description{
Checks if A) `x` is a list, B) All elements in `x` are either null or fully named lists.
}
\details{
Fully named lists are lists with each element having a name.
}
\examples{
is_all_list_elements_null_or_fully_named_list(data.frame())
is_all_list_elements_null_or_fully_named_list(list(data.frame()))
is_all_list_elements_null_or_fully_named_list(list(1, NULL))
is_all_list_elements_null_or_fully_named_list(list(list(), NULL))
is_all_list_elements_null_or_fully_named_list(list(list("a" = 1), NULL))
is_all_list_elements_null_or_fully_named_list(list("a"=1, 2))
}
