% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{spiral_raster}
\alias{spiral_raster}
\title{Add image to a track}
\usage{
spiral_raster(
  x,
  y,
  image,
  width = NULL,
  height = NULL,
  facing = c("downward", "inside", "outside", "curved_inside", "curved_outside"),
  nice_facing = FALSE,
  scaling = 1,
  track_index = current_track_index()
)
}
\arguments{
\item{x}{X-locations of the center of the image.}

\item{y}{Y-locations of the center of the image.}

\item{image}{A vector of file paths of images. The format of the image is inferred from the suffix name of the image file.
NA value or empty string means no image to drawn. Supported formats are png/svg/pdf/eps/jpeg/jpg/tiff.}

\item{width}{Width of the image. See Details.}

\item{height}{Height of the image. See Details.}

\item{facing}{Facing of the image.}

\item{nice_facing}{Whether to adjust the facing.}

\item{scaling}{Scaling factor when \code{facing} is set to \code{"curved_inside"} or \code{"curved_outside"}.}

\item{track_index}{Index of the track.}
}
\value{
No value is returned.
}
\description{
Add image to a track
}
\details{
When \code{facing} is set to one of \code{"downward"}, \code{"inside"} and \code{"outside"}, both of \code{width} and \code{height} should be \code{\link[grid:unit]{grid::unit()}} objects.
It is suggested to only set one of \code{width} and \code{height}, the other dimension will be automatically calculated from the aspect ratio of the image.

When \code{facing} is set to one of \code{"curved_inside"} and \code{"curved_outside"}, the value can also be numeric, which are the values
measured in the data coordinates. Note when the segment in the spiral that corresponds to \code{width} is very long, drawing the curved
image will be very slow because each pixel is actually treated as a single rectangle.
}
\examples{
image = system.file("extdata", "Rlogo.png", package = "circlize")
x = seq(0.1, 0.9, length = 10)

spiral_initialize()
spiral_track()
spiral_raster(x, 0.5, image)

spiral_initialize()
spiral_track()
spiral_raster(x, 0.5, image, facing = "inside")

}
