% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{spiral_polygon}
\alias{spiral_polygon}
\title{Add polygons to a track}
\usage{
spiral_polygon(
  x,
  y,
  id = NULL,
  gp = gpar(),
  track_index = current_track_index()
)
}
\arguments{
\item{x}{X-locations of the data points.}

\item{y}{Y-locations of the data points.}

\item{id}{A numeric vector used to separate locations in x and y into multiple polygons.}

\item{gp}{Graphical parameters.}

\item{track_index}{Index of the track.}
}
\value{
No value is returned.
}
\description{
Add polygons to a track
}
\examples{
x = seq(0, 2*pi*10, length = 1000)
y = c(sin(x), cos(rev(x)))
x2 = c(x, rev(x))

# in the normal cartesian coordinate system
plot(NULL, xlim = range(x2), ylim = range(y))
polygon(x2, y, col = "red")

# in the spiral coordinate system
spiral_initialize(xlim = range(x2))
spiral_track(ylim = range(y))
spiral_polygon(x2, y, gp = gpar(fill = "red"))

# try a different scale
spiral_initialize(xlim = range(x2), scale_by = "curve_length")
spiral_track(ylim = range(y))
spiral_polygon(x2, y, gp = gpar(fill = "red"))
}
