% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrogram.R
\name{spiral_phylo}
\alias{spiral_phylo}
\alias{phylo_to_dendrogram}
\title{Draw phylogenetic tree}
\usage{
spiral_phylo(
  obj,
  gp = gpar(),
  log = FALSE,
  reverse = FALSE,
  group = NULL,
  group_col = NULL,
  track_index = current_track_index()
)

phylo_to_dendrogram(obj, log = FALSE)
}
\arguments{
\item{obj}{A \code{\link[stats:dendrogram]{stats::dendrogram}} object.}

\item{gp}{Graphical parameters of the tree edges, mainly as a global setting.}

\item{log}{Whether the height of the tree to be log-transformed \code{log10(x + 1)}?}

\item{reverse}{Whether the tree to be reversed?}

\item{group}{A categorical variable for splitting the tree.}

\item{group_col}{A named vector which contains group colors.}

\item{track_index}{Index of the track.}
}
\value{
Height of the phylogenetic tree.

A \code{\link[stats:dendrogram]{stats::dendrogram}} object.
}
\description{
Draw phylogenetic tree
}
\details{
\code{\link[=phylo_to_dendrogram]{phylo_to_dendrogram()}} converts a \code{phylo} object to a \code{dendrogram} object.

The motivation is that phylogenetic tree may contain polytomies, which means at a certain node,
there are more than two children branches. Available tools that do the conversion only support binary trees.

The returned \code{dendrogram} object is not in its standard format which means it can not be properly
drawn by the \code{\link[stats:dendrogram]{stats::plot.dendrogram()}} function. However, you can still apply \code{\link[stats:cutree]{stats::cutree()}} to the returned
\code{dendrogram} object with no problem and the dendrogram can be properly drawn with the \strong{ComplexHeatmap} package (see examples).
}
\examples{
if(require(ape)) {
    data(bird.families)
    n = length(bird.families$tip.label)
    spiral_initialize(xlim = c(0, n), start = 360, end = 360*3)
    spiral_track(height = 0.8)
    spiral_phylo(bird.families)
}
if(require(ape)) {
    data(bird.families)
    d = phylo_to_dendrogram(bird.families)

    ComplexHeatmap::grid.dendrogram(d, test = TRUE)
}
}
