% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVCFit.R
\name{BVCfit}
\alias{BVCfit}
\title{fit a Semi-parametric Bayesian variable selection}
\usage{
BVCfit(
  X,
  Y,
  Z,
  E = NULL,
  clin = NULL,
  iterations = 10000,
  burn.in = NULL,
  sparse = TRUE,
  structural = TRUE,
  VC = TRUE,
  kn = 2,
  degree = 2,
  hyper = NULL,
  debugging = FALSE
)
}
\arguments{
\item{X}{the matrix of predictors (genetic factors) without intercept. Each row should be an observation vector. A column of 1 will be added to the X matrix
as the intercept.}

\item{Y}{the response variable. The current version of BVCfit only supports continuous response.}

\item{Z}{a vector of environmental factor for non-linear G×E interactions.}

\item{E}{a vector of environmental factor for linear G×E interactions.}

\item{clin}{a matrix of clinical variables. Clinical variables are not subject to penalty.}

\item{iterations}{the number of MCMC iterations.}

\item{burn.in}{the number of iterations for burn-in.}

\item{sparse}{logical flag. If TRUE, spike-and-slab priors will be used to shrink coefficients of irrelevant covariates to zero exactly. 'sparse' has effect only when VC=TRUE.}

\item{structural}{logical flag. If TRUE, the coefficient functions with varying effects and constant effects will be penalized separately. 'structural' has effect only when VC=TRUE.}

\item{VC}{logical flag. If TRUE, varying coefficient functions will be used for modeling the interactions between Z and X.
If FALSE, interactions between Z and X will be modeled as linear interactions.}

\item{kn}{the number of interior knots for B-spline.}

\item{degree}{the degree of B spline basis.}

\item{hyper}{a named list of hyperparameters.}

\item{debugging}{logical flag. If TRUE, progress will be output to the console and extra information will be returned.}
}
\value{
an object of class "BVCfit" is returned, which is a list with components:
\itemize{
\item posterior: posterior samples from the MCMC
\item coefficients: a list of posterior estimates of coefficients
\item burn.in: the number of iterations for burn-in
\item iterations: the number of MCMC iterations.
}
}
\description{
fit a Bayesian semi-parametric model for both linear and non-linear G×E interactions. Users can also specify all the interactions as linear and fit a Bayesian LASSO type of model.
}
\details{
By default, varying coefficient functions are used for modeling the nonlinear interactions between Z and X. Assuming both E and clin are NULL, the model can be expressed as
\deqn{Y = \beta_{0}(Z)+\sum\beta_{j}(Z)X_{j} + \epsilon }
The basis expansion and changing of basis with B splines will be done automatically:
\deqn{\beta_{j}(\cdot)\approx \gamma_{j1} + \sum_{k=2}^{q}{B}_{jk}(\cdot)\gamma_{jk}}
where \eqn{B_{jk}(\cdot)} represents B spline basis. \eqn{\gamma_{j1}} and \eqn{(\gamma_{j2}, \ldots, \gamma_{jq})^\top} correspond to the constant and varying parts of the coefficient functional, respectively.
q=kn+degree+1 is the number of basis functions. By default, kn=degree=2. User can change the values of kn and degree to any other positive integers.
If E is provided, the linear interactions between E and X will be added modeled as pairwise-products:
\deqn{Y = \beta_{0}(Z)+\sum\beta_{j}(Z)X_{j} + \zeta_{0}E + \sum \zeta_{j}EX_{j} + \epsilon}
If clin is provided, clinical variables
will be added to the model.

If VC=FALSE, all interactions are treated as linear and a Bayesian LASSO model will be used. With non-null values of E and clin, the full linear model is:
\deqn{Y \sim Z + ZX + clin + E + EX}
Please check the references for more details about the model.

Users can modify the hyper-parameters by providing a named list of hyper-parameters via the argument 'hyper'.
The list can have the following named components
\itemize{
  \item a.c, a.v, a.e: shape parameters of the Gamma priors on \eqn{\lambda_{c}}, \eqn{\lambda_{v}} and \eqn{\lambda_{e}}, respectively.
  \item b.c, b.v, b.e: rate parameters of the Gamma priors on \eqn{\lambda_{c}}, \eqn{\lambda_{v}} and \eqn{\lambda_{e}}, respectively.
  \item r.c, r.v, r.e: shape parameters of the Beta priors (\eqn{\pi^{r-1}(1-\pi)^{w-1}}) on \eqn{\pi_{c}}, \eqn{\pi_{v}} and \eqn{\pi_{e}}, respectively.
  \item w.c, w.v, w.e: shape parameters of the Beta priors on \eqn{\pi_{c}}, \eqn{\pi_{v}} and \eqn{\pi_{e}}, respectively.
  \item s: shape parameters of the Inverse-gamma prior on \eqn{\sigma^{2}}.
  \item h: scale parameters of the Inverse-gamma prior on \eqn{\sigma^{2}}.
}
Please check the references for more details about the prior distributions.
}
\examples{
data(gExp)

## default method
spbayes=BVCfit(X, Y, Z, E, clin)
spbayes

\donttest{
## non-structural
structural=FALSE
spbayes=BVCfit(X, Y, Z, E, clin, structural=structural)
spbayes

## non-sparse
sparse=FALSE
spbayes=BVCfit(X, Y, Z, E, clin, sparse=sparse)
spbayes
}

}
\references{
Ren, J., Zhou, F., Li, X., Chen, Q., Zhang, H., Ma, S., Jiang, Y., Wu, C. (2020) Semiparametric Bayesian variable selection for gene-environment interactions.
{\emph{Statistics in Medicine}, 39(5): 617– 638} \doi{10.1002/sim.8434}
}
\keyword{models}
