% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sperrorest_misc.R
\name{get_small_tiles}
\alias{get_small_tiles}
\title{Identify small partitions that need to be fixed.}
\usage{
get_small_tiles(tile, min_n = NULL, min_frac = 0, ignore = c())
}
\arguments{
\item{tile}{factor: tile/partition names for all samples; names must be
coercible to class \link{tilename}, i.e. of the form \code{'X4:Y2'} etc.}

\item{min_n}{integer (optional): minimum number of samples per partition_}

\item{min_frac}{numeric >0, <1: minimum relative size of partition as
percentage of sample.}

\item{ignore}{character vector: names of tiles to be ignored, i.e. to be
retained even if the inclusion criteria are not met.}
}
\value{
character vector: names of tiles that are considered 'small'
according to these criteria
}
\description{
\code{get_small_tiles} identifies partitions (tiles) that are too
small according to some defined criterion / criteria (minimum number of
samples in tile and/or minimum fraction of entire dataset).
}
\examples{
# Muenchow et al. (2012), see ?ecuador
# Rectangular partitioning without removal of small tiles:
parti <- partition_tiles(ecuador, nsplit = c(10, 10), reassign = FALSE)
summary(parti)
length(parti[[1]])
# Same in factor format for the application of get_small_tiles:
parti_fac <- partition_tiles(ecuador,
  nsplit = c(10, 10), reassign = FALSE,
  return_factor = TRUE
)
get_small_tiles(parti_fac[[1]], min_n = 20) # tiles with less than 20 samples
parti2 <- partition_tiles(ecuador,
  nsplit = c(10, 10), reassign = TRUE,
  min_n = 20, min_frac = 0
)
length(parti2[[1]]) # < length(parti[[1]])
}
\seealso{
\link{partition_tiles}, \link{tilename}
}
