% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spemd.r
\name{spEMD}
\alias{spEMD}
\title{spEMD}
\usage{
spEMD(data, zcol = "z", method = "splines", n.imf.max = 10,
  n.sp.max = 5, n.extrema.min = 1, stoprule = "mean.imf",
  stoprule.extrema = TRUE, thresh.extrema = 1, tol = 0,
  diff.nb.extrema = 0.05, abs.nb.extrema = 5, nb.nn = 4,
  n.pts.spline = 4, neig = NULL, save_neig = TRUE, verbose = TRUE)
}
\arguments{
\item{data}{Input dataset, either a `data.frame` or a `Spatial*DataFrame`}

\item{zcol}{Name of the column containing the attribute of interest.}

\item{method}{Interpolation method. Currently only `splines` is supported.}

\item{n.imf.max}{Maximum depth of decomposition (maximum number of IMF).}

\item{n.sp.max}{Number of iterations in the sifting process.}

\item{n.extrema.min}{Minimum number of extrema.}

\item{stoprule}{Rule used to stop the EMD process. Currently only `mean.imf` is implemented.}

\item{stoprule.extrema}{Should `spEMD` checks for the number of extrema to be similar? Defaults to `TRUE`.}

\item{thresh.extrema}{Significative threshold for the extrema. Defaults to 1.}

\item{tol}{Value that the avergae of the IMF candidate need to reach so to be considered as a valid IMF.}

\item{diff.nb.extrema}{Percentage limit difference maxima/minima. If smaller, more permissive on the mean of the IMF candidate.}

\item{abs.nb.extrema}{Absolute difference between number of extrema.}

\item{nb.nn}{Number of nearest neighbours to take into account (when data is on a regular grid).}

\item{n.pts.spline}{Number of points to locally interpolate IMFs.}

\item{neig}{Option the re-use a formerly existing neig object in order to save time.}

\item{save_neig}{Option to save the neig object as a .RData file once created.}

\item{verbose}{Prints progress information messages. Defaults to TRUE.}
}
\value{
.
}
\description{
2D EMD for spatial objects
}
\examples{

# Getting sample data from the gstat package
if (require(gstat)) {
library(sp)

# Example for gridded data
data(ncp.grid, package = 'gstat')
coordinates(ncp.grid) <- ~x+y
gridded(ncp.grid) <- TRUE
res.ncp <- spEMD(ncp.grid, zcol = "depth", thresh.extrema = 0.1, verbose = FALSE)

# Plot results
spplot(res.ncp[, c('imf1', "imf2", "imf3")])
}

#


}
\author{
Pierre Roudier
}
