% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panelReg.R
\name{panelReg}
\alias{panelReg}
\title{Fits Semiparametric Regression Models for Panel Count Survival Data}
\usage{
panelReg(formula, data, method = c("AEE", "AEEX", "HWZ", "MPL", "MPLs",
  "MLs", "AMM", "EE.SWa", "EE.SWb", "EE.SWc", "EE.HSWc", "EE.HSWm"),
  se = c("NULL", "smBootstrap", "Bootstrap", "Impute", "Sandwich"),
  control = list())
}
\arguments{
\item{formula}{A formula object, with the response on the left of a
"~" operator, and the terms on the right. The response must be a
panel count survival object as returned by function \code{PanelSurv}.}

\item{data}{A data.frame in which to interpret the variables named in
the \code{formula}. Three variables including subjects' id,
observation times, and number of new events since last
observation time are required to feed into function
\code{PanelSurv} as response. At least one covariate variable is required.}

\item{method}{Fitting method. See \sQuote{Details}.}

\item{se}{Standard error estimation method. See \sQuote{Details}.}

\item{control}{A list of control parameters. See \sQuote{Details}.}
}
\value{
An object of S3 class \code{"panelReg"} representing the fit.
See \code{panelReg.object} for details.
}
\description{
Fits an proportional means model:
\deqn{\Lambda (t; X_i) = E[N_i(t)|X_i] = \Lambda(t)e^{X_i ' \beta},}
where \eqn{\beta} is a \eqn{p \times 1} vector of covariate
coefficient and \eqn{\Lambda(\cdot)} is a completely unspecified
baseline mean function.

Estimating procedures include: Wang-Yan's augmented estimating
equations (\code{"AEE"}, \code{"AEEX"}),
Huang-Wang-Zhang's method (\code{"HWZ"}),
Zhang's maximum pseudo-likelihood (\code{"MPL"}),
Maximum pseudolikelihood with I-Splines (\code{"MPLs"}),
Maximum likelihood with I-Splines (\code{"MLs"}),
Sun-Wei's method (\code{"EE.SWa"}, \code{"EE.SWb"}, \code{"EE.SWc"}),
and Hu-Sun-Wei's method (\code{"EE.HSWc"}, \code{"EE.HSWm"}).

The function can also fits an accelerated mean model (\code{"AMM"}):
\deqn{\Lambda (t; X_i) = E[N_i(t)|X_i] = \Lambda(te^{X_i ' \beta})e^{X_i ' \beta}.}
}
\details{
Some assumptions details about the observation times and censoring
time need clarification. Three possible scenarios of observation
times are considered: 1) independent observation times -- the
observation times are independent of the underlying recurrent event
process; 2) conditional independent observation times -- the
observation times are independent of the event process given
observed covariates; 3) informative observation times -- after
conditioning on observed covariates, the observation times and the
event process are still dependent through an unobserved
multiplicative frailty. Similarly, the three scenarios apply to the
censoring time.

\code{"AEE"} and \code{"AEEX"} are the augmented estimating
 equation methods under conditional independent censoring and
 informative censoring respectively. Both allow informative observation times.

\code{"HWZ"} is Huang-Wang-Zhang's method. It allows both
  information observation times and informative censoring time. It does
  not need to specify the dependence structure or model the frailty.

\code{"MPL"} and \code{"MPLs"} are maximum pseudolikelihood
  methods, with nonparametric and monotone spline estimates of the baseline
  mean function respectively. They assume conditional independent
  observation times and censoring time. The underlying event process
  is assumed to be Poisson, and the within subjects dependence is ignored.

 \code{"MLs"} is maximum likelihood method with monotone splines
  estimates of the baseline mean function. It assumes conditional
  independent observation times and censoring time, and a Poisson
  underlying event process.

\code{"EE.SWa"}, \code{"EE.SWb"} and \code{"EE.SWc"} are estimating
  equation approaches based on Sun-Wei's methods.
  The first assumes independent observation times and censoring
  time. The second assumes conditional independent observation times but
  independent censoring time. The third assumes conditional independent
  observation times and censoring time. All three variations work on
  centered covariates and avoid estimating the baseline mean.

 \code{"EE.HSWc"} and \code{"EE.HSWm"} are estimating
  equation approaches based on Hu-Sun-Wei's methods.
  The first assumes independent observation times and censoring
  time. The second assumes conditional independent observation times but
  independent censoring time. Both variations work on centered covariates
  and avoid estimating the baseline mean.

\code{"AMM"} is the accelerated mean model.
  The observation time process is allowed to be correlated with
  the underlying recurrent event process through a frailty variable,
  which does not need to be specified. The model also allows marginal
  interpretations for the regression parameters and connects naturally
  with AFT model. See Chiou et al. (2017) for more details.

For standard errors estimation method:

  \code{"NULL"} means do not calculate standard errors;
  \code{"smBootstrap"} is the smoothed bootstrap estimation method
  that works with \code{"AMM"}.
  \code{"Bootstrap"} works with all fitting methods; \code{"Impute"} is
  the multiple imputation method that works with \code{"AEE"} and
  \code{"AEEX"}; \code{"Sandwich"} is the robust sandwich estimation
  method that works with \code{"AEE"} and \code{"AEEX"}.

  The \code{control} argument is a list that can supply any of the
  following components:
  \describe{
    \item{\code{betaInit}:}{Object of class \code{"numeric"},
      initial value for covariate coefficient, default \code{0}.}
    \item{\code{interval}:}{Object of class \code{"numeric"},
      initial search interval for solving \code{beta}, default
      \code{(-5, 5)}.}
    \item{\code{maxIter}:}{Object of class \code{"numeric"}, maximum
      iteration allowed, default \code{500} for \code{"AEEX"} and
      \code{"HWZ"}, \code{150} for others.}
    \item{\code{absTol}:}{Object of class \code{"numeric"}, absolute
      tolerance, default \code{1e-6}.}
    \item{\code{relTol}:}{Object of class \code{"numeric"}, relative
      tolerance, default \code{1e-6}.}
    \item{\code{a}:}{Object of class \code{"numeric"}, a tune parameter,
      default \code{0.1}. In the case of gamma frailty, \code{"a"}
      corresponds to the value of both shape and rate parameters.}
    \item{\code{R}:}{Object of class \code{"numeric"}, number of
      bootstrap or imputation, default 30.}
  }
}
\examples{
\dontrun{
data(blaTum)
## Fit the bladder tumor data set
formula <- PanelSurv(id, time, count) ~ num + size + treatment

panelReg(formula, data = blaTum, method = "AEE", se = "Sandwich")
panelReg(formula, data = blaTum, method = "AEEX", se = "Impute",
         control = list(a = 0.1, R = 30))
panelReg(formula, data = blaTum, method = "HWZ", se = "Bootstrap",
         control = list(R = 30))
panelReg(formula, data = blaTum, method = "MLs", se = "NULL")
panelReg(formula, data = blaTum, method = "EE.SWa", se = "Bootstrap",
         control = list(R = 30))
panelReg(formula, data = blaTum, method = "EE.HSWc", se = "Bootstrap",
         control = list(R = 30))
}

}
\references{
Chiou, S., Xu, G., Yan, J., and Huang, C.-Y. (2017).
Semiparametric estimation of the accelerated mean model with panel count data under
informative examination times. \emph{Biometrics}, to appear.
<doi: 10.1111/biom.12840>.

Huang, C.-Y., Wang, M., and Zhang, Y. (2006).
Analysing panel count data with informative observation times.
\emph{Biometrika}, \bold{93}(4), 763--776.

Hu, X. J., Sun, J. and Wei, L. J. (2003).
Regression parameter estimation from panel counts.
\emph{Scandinavian Journal of Statistics}, \bold{30}, 25--43.

Lu, M., Zhang, Y., and Huang, J. (2007).
Estimation of the mean function with panel count data using monotone polynomial splines.
\emph{Biometrika}, \bold{94}(3), 705--718.

Sun, J. and Wei, L. J. (2000). Regression analysis of panel count
data with covariates-dependent observation and censoring times.
\emph{Journal of the Royal Statistical Society, Series B: Statistical Methodology},
\bold{62}(2), 293--302.

Wang, X. and Yan, J. (2011). Fitting semiparametric regressions for panel
count survival data with an R package spef.
\emph{Computer Methods and Programs in Biomedicine}, \bold{104}(2), 278--285.

Wang, X. and Yan, J. (2013). Augmented estimating equations for
semiparametric panel count regression with informative observation
times and censoring time. \emph{Statistica Sinica}, 359--381.

Zhang, Y. (2002). A Semiparametric pseudolikelihood estimation method
for panel count data. \emph{Biometrika}, \bold{89}(1), 39--48.
}
\seealso{
\code{\link{panelReg.object}}
}
