% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{BBTm.no.formula}
\alias{BBTm.no.formula}
\title{Bayesian Bradley--Terry model with comparison specific effect}
\usage{
BBTm.no.formula(
  outcome,
  player1,
  player2,
  player.prior.var,
  lambda.initial,
  advantage = NULL,
  kappa.initial = NULL,
  kappa.var = NULL,
  n.iter = 1000,
  hyperparameter = TRUE,
  chi = 0.01,
  psi = 0.01
)
}
\arguments{
\item{outcome}{vector of outcomes. 1 if player2 is the winner,
0 if player1 is the winner}

\item{player1}{vector of first players.}

\item{player2}{vector of second players.}

\item{player.prior.var}{(optional) matrix specifying the prior covariance of
the player correlation parameters}

\item{lambda.initial}{(optional) vector containing the values of the
player parameters for the first MCMC iteration}

\item{advantage}{(optional) a vector with the value of the comparisons specific
effect for each comparison}

\item{kappa.initial}{(optional) an initial value for the comparison specific
value kappa
@param kappa.var (optional) the prior variance of the he comparison specific
value kappa}

\item{n.iter}{number of MCMC samples to be drawn}

\item{hyperparameter}{boolean indicating if inference should be performed
for the prior variance hyperparameter. If TRUE the prior variance
(main diagonal of the covariance matrix) must be set to 1.}

\item{chi}{rate parameter for the inverse-gamma prior distribution on the
hyperparameter}

\item{psi}{shape parameter for the inverse-gamma prior distribution on the
hyperparameter}
}
\value{
A data frame containing samples from the posterior distribution
}
\description{
This function fits the Bradley-Terry model with a comparison specific effect.
Each comparison can be assigned a real value to allow for a specific effect
for the comparison, such as bias, ordering or home/away effect. The value of
this effect is denoted $kappa$. The function places a normal prior distribution
on both kappa and the player quality parameters lambda.
}
\details{
If \code{player.prior.var} is omitted, independent and identical
N(0, 5^2) prior distributions are placed on each object quality parameter.

If \code{lambda.initial} is omitted, it is set to a vector of zeroes.

If \code{lambda.var} is omitted, it is set to N(0, 5^2).
}
\keyword{internal}
