% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{BBTm}
\alias{BBTm}
\title{Generalised Bradley-Terry model}
\usage{
BBTm(
  outcome,
  player1,
  player2,
  lambda.initial = NULL,
  player.prior.var = NULL,
  beta.initial = NULL,
  n.iter = 1000,
  formula = NULL,
  data = NULL,
  advantage = NULL,
  kappa.initial = NULL,
  kappa.var = NULL,
  hyperparameter = TRUE,
  chi = 0.01,
  psi = 0.01
)
}
\arguments{
\item{outcome}{vector of outcomes. 1 if player2 is the winner,
0 if player1 is the winner}

\item{player1}{vector of first players.}

\item{player2}{vector of second players.}

\item{lambda.initial}{(optional) vector containing the values of the
player parameters for the first MCMC iteration}

\item{player.prior.var}{(optional) matrix specifying the prior covariance of
the player correlation parameters}

\item{beta.initial}{(optional) vector containing the values of the
player specific  parameters for the first MCMC iteration}

\item{n.iter}{number of MCMC samples to be drawn}

\item{formula}{formula with no left-hand-side specifying the player specific
effects}

\item{data}{data.frame with a row corresponding to each player and  column corresponding
to each covariate.}

\item{advantage}{(optional) a vector with the value of the comparisons specific
effect for each comparison}

\item{kappa.initial}{(optional) an initial value for the comparison specific
value kappa}

\item{kappa.var}{(optional) the prior variance of the he comparison specific
value kappa}

\item{hyperparameter}{boolean indicating if inference should be performed
for the prior variance hyperparameter. If TRUE the prior variance
(main diagonal of the covariance matrix) must be set to 1.}

\item{chi}{rate parameter for the inverse-gamma prior distribution on the
hyperparameter}

\item{psi}{shape parameter for the inverse-gamma prior distribution on the
hyperparameter}
}
\value{
A data frame containing samples from the posterior distribution
}
\description{
This function fits the Bradley-Terry model with comparison  and player
specific effects. Each comparison can be assigned a real value to allow for a
specific effect for the comparison, such as bias, ordering or home/away effect.
The value of this effect is denoted kappa. The player specific effects are
described through a formula and data.frame containing the value. The function
places a normal prior distribution on both kappa and the player specific
parameters beta.
}
\details{
If \code{player.prior.var} is omitted, independent and identical
N(0, 5^2) prior distributions are placed on each object quality parameter.

If \code{beta.initial}is omitted, it is set to a vector of zeroes.

If \code{kappa.var} is omitted, it is set to N(0, 5^2), if \code{kappa.initial} is omitted
it is set to 0.5.
}
\examples{

#####################
## Wimbledon 2019 ##
####################

#Fit model where the quality of each player depends on their rank
#and the number of points they had immediately before the tournament.
#Allow an effect for a match being in the first or second week.
#wimbledonModel <- BBTm(outcome  = wimbledon$matches$outcome,
#                      player2   = wimbledon$matches$loser,
#                       player1  = wimbledon$matches$winner,
#                      advantage = wimbledon$matches$secondWeek,
#                      formula  = ~ rank + points,
#                      data       = wimbledon$players,
#                       n.iter = 4000)

#Plot posterior distributions
 #hist(wimbledonModel$kappa[-c(1:100)], main = "", xlab = expression(kappa), freq  = FALSE)
 #hist(wimbledonModel$beta[-c(1:100), 1], main = "", xlab = expression(beta[1]), freq  = FALSE)
 #hist(wimbledonModel$beta[-c(1:100), 2], main = "", xlab = expression(beta[2]), freq  = FALSE)


}
