% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary.r
\name{plot_summary}
\alias{plot_summary}
\title{Create box plots for given analytical choices}
\usage{
plot_summary(df, choices = c("x", "y", "model", "controls", "subsets"))
}
\arguments{
\item{df}{a data frame resulting from \code{run_specs()}.}

\item{choices}{a vector specifying which analytical choices should be plotted. By default, all choices are plotted.}
}
\value{
a \link[ggplot2]{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function is deprecated because the new version of specr uses a new analytic framework.
In this framework, you can plot a similar figure simply by using the generic \code{plot()} function and adding the argument \code{type = "boxplot"}.
This function provides a convenient way to visually investigate the effect of individual choices on the estimate of interest. It produces box-and-whisker plot(s) for each provided analytical choice.
}
\examples{
# run spec analysis
results <- run_specs(example_data,
                     y = c("y1", "y2"),
                     x = c("x1", "x2"),
                     model = "lm",
                     controls = c("c1", "c2"),
                     subset = list(group1 = unique(example_data$group1)))

# plot boxplot comparing specific choices
plot_summary(results, choices = c("subsets", "controls", "y"))
}
\seealso{
\code{\link[=summarise_specs]{summarise_specs()}} to investigate the affect of analytical choices in more detail.
}
