% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_choices.r
\name{plot_choices}
\alias{plot_choices}
\title{Plot how analytical choices affect results}
\usage{
plot_choices(
  df,
  var = .data$estimate,
  group = NULL,
  choices = c("x", "y", "model", "controls", "subsets"),
  desc = FALSE,
  null = 0
)
}
\arguments{
\item{df}{a data frame resulting from \code{run_specs()}.}

\item{var}{which variable should be evaluated? Defaults to estimate (the effect sizes computed by \code{\link[=run_specs]{run_specs()}}).}

\item{group}{Should the arrangement of the curve be grouped by a particular choice?
Defaults to NULL, but can be any of the present choices (e.g., x, y, controls...)}

\item{choices}{a vector specifying which analytical choices should be plotted. By default, all choices are plotted.}

\item{desc}{logical value indicating whether the curve should the arranged in a descending order. Defaults to FALSE.}

\item{null}{Indicate what value represents the 'null' hypothesis (Defaults to zero).}
}
\value{
a \link[ggplot2]{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function is deprecated because the new version of specr uses a new analytic framework.
In this framework, you can plot a similar figure simply by using the generic \code{plot()} function.
and adding the argument \code{type = "choices"}.
This functions plots how analytic choices affect the obtained results (i.e., the rank within the curve). Significant results are highlighted (negative = red, positive = blue, grey = nonsignificant). This functions creates the lower panel in \code{plot_specs()}.
}
\examples{
# Run specification curve analysis
results <- run_specs(df = example_data,
                     y = c("y1", "y2"),
                     x = c("x1", "x2"),
                     model = c("lm"),
                     controls = c("c1", "c2"),
                     subsets = list(group1 = unique(example_data$group1),
                                    group2 = unique(example_data$group2)))

# Plot simple table of choices
plot_choices(results)

# Plot only specific choices
plot_choices(results,
             choices = c("x", "y", "controls"))
}
