% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_plots.R
\name{distribution_plots}
\alias{distribution_plots}
\title{per_unit_counts: Generates distribution plots of spot/cell meta data or gene expression}
\usage{
distribution_plots(
  x = NULL,
  plot_meta = NULL,
  genes = NULL,
  samples = NULL,
  data_type = "tr",
  color_pal = "okabeito",
  plot_type = "violin",
  ptsize = 0.5,
  ptalpha = 0.5
)
}
\arguments{
\item{x}{an STlist}

\item{plot_meta}{vector of variables in \code{x@spatial_meta} to plot distributions.
If 'total_counts', the function plots the counts per spot/cell. If 'total_genes',
the function plots the number of genes per spot/cell are plotted}

\item{genes}{vector of genes to plot expression distribution. If used in conjunction
with \code{plot_meta}, the expression values are grouped using that variable}

\item{samples}{samples to include in the plot. Default (NULL) includes all samples}

\item{data_type}{one of 'tr' or 'raw', to plot transformed or raw counts}

\item{color_pal}{a string of a color palette from \code{khroma} or \code{RColorBrewer}, or a
vector with colors}

\item{plot_type}{one of "violin", "box", or "density" (violin plots, box plots, or
density plots respectively). If \code{plot_meta} and \code{gene} are used together, then
density plots are disabled}

\item{ptsize}{the size of points in the plots}

\item{ptalpha}{the transparency of points (violin/box plot) or curves (density plots)}
}
\value{
a list containing \code{ggplot2} objects
}
\description{
Generates violin plots, boxplots, or density plots of variables in the
spatial meta data or of gene expression
}
\details{
The function allows to visualize the distribution of spot/cell total
counts, total genes, or expression of specific genes across all samples for
comparative purposes. It also allows grouping of gene expression values by
categorical variables (e.g., clusters).
}
