% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.r
\name{quadform_inv}
\alias{quadform_inv}
\title{Quadratic Form of the inverse of a matrix and a vector}
\usage{
quadform_inv(A, x)
}
\arguments{
\item{A}{matrix that is p x p and nonsingular}

\item{x}{vector of length p}
}
\value{
scalar value
}
\description{
We compute the quadratic form of a vector and the inverse of a matrix in an
efficient manner. Let \code{x} be a real vector of length \code{p}, and let
\code{A} be a p x p nonsingular matrix. Then, we compute the quadratic form
\eqn{q = x' A^{-1} x}.
}
\details{
A naive way to compute the quadratic form is to explicitly write
\verb{t(x) \\\%*\\\% solve(A) \\\%*\\\% x}, but for large \code{p}, this operation is
inefficient. We provide a more efficient method below.

Note that we have adapted the code from:
\url{https://stat.ethz.ch/pipermail/r-help/2005-November/081940.html}
}
