% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tri_constraint_constructor.R
\name{make_summation_matrix}
\alias{make_summation_matrix}
\title{Construct symmetry constraint matrix for bivariate symmetric smoothing.}
\usage{
make_summation_matrix(F, skew = FALSE, cyclic.degree = 0)
}
\arguments{
\item{F}{number of marginal basis functions.}

\item{skew}{logical, should the basis be constraint to skew-symmetry instead
of symmetry.}

\item{cyclic.degree}{integer, specifying the number of basis functions identified
with each other at the boundaries in order to implement periodicity. Should
be specified to match the degree of the utilized B-spline basis.}
}
\value{
A basis transformation matrix of dimension \eqn{F^2 \times G} with
\eqn{G<F^2} depending on the specified constraint.
}
\description{
This function can be used to construct a symmetry constraint matrix that imposes
a (skew-)symmetry constraint on (cyclic) spline coefficients in symmetric bivariate smoothing problems and is especially
designed for constructing objects of the class "symm.smooth", see \code{\link[sparseFLMM]{smooth.construct.symm.smooth.spec}}.
}
\details{
Imposing a symmetry constraint to the spline coefficients in order to obtain a reduced coefficient vector is
equivalent to right multiplication of the bivariate design matrix
with the symmetry constraint matrix obtained with function \code{make_summation_matrix}.
The penalty matrix of the bivariate smooth needs to be adjusted to the reduced coefficient vector
by left and right multiplication with the symmetry constraint matrix.
This function is used in the constructor function \code{\link[sparseFLMM]{smooth.construct.symm.smooth.spec}}.
}
\references{
Cederbaum, Scheipl, Greven (2016): Fast symmetric additive covariance smoothing.
Submitted on arXiv.
}
\seealso{
\code{\link[mgcv]{smooth.construct}} and \code{\link[mgcv]{smoothCon}} for details on constructors
}
\author{
Jona Cederbaum, Almond Stoecker
}
