% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{predict.sparseDFM}
\alias{predict.sparseDFM}
\alias{print.sparseDFM_forecast}
\title{Forecasting factor estimates and data series.}
\usage{
\method{predict}{sparseDFM}(object, h = 1, standardize = FALSE, alpha_index = "best", ...)

\method{print}{sparseDFM_forecast}(x, ...)
}
\arguments{
\item{object}{an object of class 'sparseDFM'.}

\item{h}{integer. The number of steps ahead to compute the forecast for. Default is \eqn{h=1}{h=1}.}

\item{standardize}{logical. Returns data series forecasts in the original data scale if set to \code{FALSE}. Default is \code{FALSE}.}

\item{alpha_index}{Choose which L1 penalty parameter to display the results for. Default is 'best'. Otherwise, input a number between 1:length(alpha_grid) that indicates the required alpha parameter.}

\item{\dots}{Further \code{print} arguments.}

\item{x}{an object of class 'sparseDFM_forecast' from \code{predict.sparseDFM}.}
}
\value{
X_hat \eqn{h \times p}{h x p} numeric matrix of data series forecasts.

F_hat \eqn{h \times r}{h x r} numeric matrix of factor forecasts.

e_hat \eqn{h \times p}{h x p} numeric matrix of AR(1) idiosyncratic error forecasts if \code{err}=\code{AR1} in \code{sparseDFM}.

h forecasts produced for h steps ahead.

err the type of idiosyncratic errors used in \code{sparseDFM}.

Prints out the h-step ahead forecast from \code{predict.sparseDFM}.
}
\description{
Predict the next h steps ahead for the factor estimates and the data series. Given information up to time \eqn{t}{t}, a h-step ahead forecast is \eqn{\bm{X}_{t+h}=\bm{\Lambda}\bm{A}^{h}\bm{F}_t+\bm{\Phi}^h\bm{\epsilon}_t}{X_{t+h}=\Lambda A^h F_t+\Phi^h \epsilon_t}, where \eqn{\bm{\Phi}=0}{\Phi = 0} for the IID idiosyncratic error case.
}
