% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleMVN.R
\name{sampleMVN}
\alias{sampleMVN}
\title{This function samples MVN based on a given covariance matrix}
\usage{
sampleMVN(n, Sigma, sparse = TRUE, n_cores = 1, fastmvn = FALSE)
}
\arguments{
\item{n}{The sample size.}

\item{Sigma}{The covariance matrix.}

\item{sparse}{The indicator of sparse sampling or not.}

\item{n_cores}{The number of cores used.}

\item{fastmvn}{The indicator of fast sampling or not.}
}
\value{
The data matrix sampled from the covariance matrix.
}
\description{
This function samples MVN based on a given covariance matrix
}
\examples{
## generate data from a block diagonal covariance matrix structure
n <- 50
p <- 30
data.true.cov <- block.true.cov(p)
data <- sampleMVN(n, data.true.cov, sparse=TRUE)
data[1:10, 1:10]
}
