% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinar_sim.R
\name{spinar_sim}
\alias{spinar_sim}
\title{Simulation of (semi)parametric integer autoregressive (INAR) models}
\usage{
spinar_sim(n, p, alpha, pmf, prerun = 500)
}
\arguments{
\item{n}{[\code{integer(1)}]\cr
number of observations.}

\item{p}{[\code{integer(1)}]\cr
lag of the INAR(\code{p}) model, where \code{p} \eqn{\in \{1,2\}}.}

\item{alpha}{[\code{integer(p)}]\cr
vector of INAR coefficients \eqn{\code{alpha}_1,...,\code{alpha}_p}.}

\item{pmf}{[\code{numeric}]\cr
vector of probability mass function
\eqn{\code{pmf}_0,..., \code{pmf}_k} where \eqn{\code{pmf}_i}
represents the probability of an innovation being equal to \eqn{i}.}

\item{prerun}{[\code{integer(1)}]\cr
number of observations which are generated additionally and then omitted
(to ensure stationarity).}
}
\value{
Vector with \eqn{n} INAR(\code{p}) observations.
}
\description{
Generating INAR(p) observations,
where \code{p} \eqn{\in \{1,2\}}. It allows for general pmfs
which can be generated parametrically or "manually" (semiparametrically).
}
\examples{
# generate (semiparametrically) 100 INAR(1) observations with
# alpha_1 = 0.5 and a manually set pmf
spinar_sim(n = 100, p = 1, alpha = 0.5, pmf = c(0.3, 0.3, 0.2, 0.1, 0.1))

# generate 100 obervations of an INAR(2) model with
# alpha_1 = 0.2, alpha_2 = 0.3 and Poi(1)-innovations
spinar_sim(n = 100, p = 2, alpha = c(0.2, 0.3), pmf = dpois(0:20,1))

}
