% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BPS_weights_MvT}
\alias{BPS_weights_MvT}
\title{Compute the BPS weights by convex optimization}
\usage{
BPS_weights_MvT(data, priors, coords, hyperpar, K)
}
\arguments{
\item{data}{\link{list} two elements: first named \eqn{Y}, second named \eqn{X}}

\item{priors}{\link{list} priors: named \eqn{\mu_B},\eqn{V_r},\eqn{\Psi},\eqn{\nu}}

\item{coords}{\link{matrix} sample coordinates for X and Y}

\item{hyperpar}{\link{list} two elemets: first named \eqn{\alpha}, second named \eqn{\phi}}

\item{K}{\link{integer} number of folds}
}
\value{
\link{matrix} posterior predictive density evaluations (each columns represent a different model)
}
\description{
Compute the BPS weights by convex optimization
}
\examples{
\donttest{
## Generate subsets of data
n <- 100
p <- 3
q <- 2
X <- matrix(rnorm(n*p), nrow = n, ncol = p)
Y <- matrix(rnorm(n*q), nrow = n, ncol = q)
crd <- matrix(runif(n*2), nrow = n, ncol = 2)

## Select competitive set of values for hyperparameters
alfa_seq <- c(0.7, 0.8, 0.9)
phi_seq <- c(3, 4, 5)

## Perform Bayesian Predictive Stacking within subsets
bps <- spBPS::BPS_weights_MvT(data = list(Y = Y, X = X),
                              priors = list(mu_B = matrix(0, nrow = p, ncol = q),
                                            V_r = diag(10, p),
                                            Psi = diag(1, q),
                                            nu = 3), coords = crd,
                                            hyperpar = list(alpha = alfa_seq,
                                                            phi = phi_seq),
                                            K = 5)
}

}
