% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sonar.R
\name{SpeedOfSoundAir}
\alias{SpeedOfSoundAir}
\title{speed of sound in humid air at sea level air density and known atmospheric pressure}
\usage{
SpeedOfSoundAir(temperatureC, Hr, pressurekPa)
}
\arguments{
\item{temperatureC}{numeric, temperature in degrees Celsius in the range -30 C to 43 C}

\item{Hr}{numeric, relative humidity, accurate to within 0.1\% for temperatures}

\item{pressurekPa}{numeric, atmospheric pressure in kPa}
}
\value{
the speed of sound (m/s)
}
\description{
Returns the speed of sound in humid air at sea level air density
and known atmospheric pressure
}
\examples{
#Speed of sound (Humid air, at sea level air density)
#temperature 20 C, 90\\\% relative humidity, 101 kPa atmosphere pressure
SpeedOfSoundAir(20, 0.9, 101)
}
\author{
Jose Gama
}
\references{
Kleeman L. & Kuc R., 2008
Springer Handbook of Robotics, Bruno Siciliano, Oussama Khatib (Eds.)
Springer-Verlag Berlin Heidelberg, pp.496 eq (21.8).
}

