% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.set.R
\name{som.nn.set}
\alias{som.nn.set}
\title{Set parameters for k-NN-like classifier in som.nn model}
\usage{
som.nn.set(
  model,
  x,
  dist.fun = NULL,
  max.dist = NULL,
  strict = NULL,
  name = NULL
)
}
\arguments{
\item{model}{model of type \code{SOMnn}.}

\item{x}{data.fame with training data. Samples are requested as rows and taken randomly for the
training steps. All
columns except of the class lables are considered to be attributes and parts of
the training vector.
\code{x} must include the same columns as the data.frame with which the model
have been trained originally.
One column is needed as class labels. The column with class
lables is selected by the slot \code{class.idx} of the model.}

\item{dist.fun}{distance function for weighting distances between codebook
vectors on the som (kernel for k-NN classifier).}

\item{max.dist}{maximum distance to be considered by the nearest-neighbour counting.}

\item{strict}{strictness for class label assignment. Default = 0.8.}

\item{name}{new name of the model.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{    S4 object of type \code{\link{SOMnn}} with the updated model.
}\if{html}{\out{</div>}}
}
\description{
Parameters for the k-NN-like classification can be set for an existing model of type SOMnn
after training.
}
\details{
The distance function defines the behaviour of the k-nearest-neighbour algorithm.
Choices for the distance function include \code{dist.fun.inverse} or \code{dist.fun.tricubic},
as defined in this package, or any other function that accepts exactly two arguments \code{x}
(the distance) and \code{sigma} (a parameter defined by max.distance).

A data set must be presented to calculate the accuracy statistics of the
modified predictor.
}
\seealso{
\code{\link{dist.fun.bubble}}, \code{\link{dist.fun.linear}},
\code{\link{dist.fun.inverse}}, \code{\link{dist.fun.tricubic}}.
}
