% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.accuracy.R
\name{som.nn.all.accuracy}
\alias{som.nn.all.accuracy}
\title{Calculate overall accuracy}
\usage{
som.nn.all.accuracy(x, class.labels)
}
\arguments{
\item{x}{\code{data.frame} with the predictions as returned by the
SOM.nn predict method.}

\item{class.labels}{\code{vector} of correct class labels for the predictions.}
}
\value{
\code{one value} overall accuracy.
}
\description{
Calculates the accuracy over all class lables for a prediction result
if the corresponding vector of true class labels
is provided.
}
\details{
It is defined as

\deqn{acc = (TP + TN) / total = sum(diag(cmat)) / sum(cmat)}

with  TP = true positives, TN = true negatives and total = total number of samples of a class.
This is equivalent to the
ratio of (correctly classified samples) / (total number of samples).
}
