% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.distance.functions.R
\name{dist.fun.inverse}
\alias{dist.fun.inverse}
\title{Inverse exponential distance functions for topological k-NN classifier}
\usage{
dist.fun.inverse(x, sigma = 1.1)
}
\arguments{
\item{x}{Distance or \code{numeric} vector or matrix of distances.}

\item{sigma}{Maximum distance to be considered. Default is 1.1.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{  Distance-dependent weight.
}\if{html}{\out{</div>}}
}
\description{
The function is used as distance-dependent weight \eqn{w} for k-NN voting.
}
\details{
The function returns 1.0 for \eqn{x = 0}, 0.0 for \eqn{x \ge \sigma} and

\deqn{1 / (x+1)^(1/sigma)}

for \eqn{0 < x < \sigma}.
}
