% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilchemistry.R
\name{Freundlich_D}
\alias{Freundlich_D}
\title{Freundlich isotherm for desorption data in soil}
\usage{
Freundlich_D(W = W, V = V, Ci = Ci, Cf = Cf, Cf_Des = Cf_Des, Vres= Vres,
Vfinal = Vfinal, onebyn_ads = onebyn_ads, ...)
}
\arguments{
\item{W}{Mass of soil sample (g)}

\item{V}{Volume of extractant solution (mL)}

\item{Ci}{Initial concentration (mg/L) of the added element, e.g., phosphorus}

\item{Cf}{Final or equilibrium concentration (mg/L) after adsorption of the same element}

\item{Cf_Des}{Final or equilibrium concentration (mg/L) after each desorption step of the same element}

\item{Vres}{Volume of carried over solution from previous adsorption or desorption step (mL)}

\item{Vfinal}{Final volume of the solution for each desorption step (mL)}

\item{onebyn_ads}{Values of ‘1/n’ obtained from Freundlich_A}

\item{...}{Any other argument that can be passed to base plot}
}
\value{
a - empirical constant (unitless)
1/n - empirical constant (unitless)
}
\description{
This function fits Freundlich adsorption isotherm to data pertaining to desorption of an adsorbed nutrient, e.g., phosphorus (as phosphate), sulphur (as sulphate), micronutrient cations or anions, silicon (as silicate), etc. in soil.
}
\examples{
with(data = df_sordes, Freundlich_D(W = 2, V = 20, Ci = Initial_conc, Cf = Equilibrium_conc,
Cf_Des = Cf_Des, Vres= 5, Vfinal = 20, onebyn_ads = 0.2056263))

}
\references{
Barman, M., Datta, S.P., Rattan, R.K., Meena, M.C., 2013. Sorption and desorption of nickel in soils in relation to its availability to plants. Agrochimica LVII (3), 235–249.
}
