% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_alldocs.R
\name{db_alldocs}
\alias{db_alldocs}
\title{List all docs in a given database.}
\usage{
db_alldocs(
  cushion,
  dbname,
  descending = NULL,
  startkey = NULL,
  endkey = NULL,
  limit = NULL,
  include_docs = FALSE,
  as = "list",
  disk = NULL,
  ...
)
}
\arguments{
\item{cushion}{A \code{\link{Cushion}} object. Required.}

\item{dbname}{Database name. (character)}

\item{descending}{Return in descending order? (logical)}

\item{startkey}{Document ID to start at. (character)}

\item{endkey}{Document ID to end at. (character)}

\item{limit}{Number document IDs to return. (numeric)}

\item{include_docs}{(logical) If \code{TRUE}, returns docs themselves,
in addition to IDs. Default: \code{FALSE}}

\item{as}{(character) One of list (default) or json}

\item{disk}{write to disk or not. By default, data is in the R session;
if you give a file path, we'll write data to disk and you'll get back
the file path. by default, we save in the R session}

\item{...}{Curl args passed on to \code{\link[crul]{HttpClient}}}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
List all docs in a given database.
}
\examples{
\dontrun{
user <- Sys.getenv("COUCHDB_TEST_USER")
pwd <- Sys.getenv("COUCHDB_TEST_PWD")
(x <- Cushion$new(user=user, pwd=pwd))

if ("leothelion" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="leothelion"))
}
db_create(x, dbname='leothelion')
db_bulk_create(x, mtcars, dbname="leothelion")

db_alldocs(x, dbname="leothelion")
db_alldocs(x, dbname="leothelion", as='json')
db_alldocs(x, dbname="leothelion", limit=2)
db_alldocs(x, dbname="leothelion", limit=2, include_docs=TRUE)

# curl options
res <- db_alldocs(x, dbname="leothelion", verbose = TRUE)

# write data to disk - useful when data is very large
## create omdb dataset first
file <- system.file("examples/omdb.json", package = "sofa")
strs <- readLines(file)
if ("omdb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="omdb"))
}
db_create(x, dbname='omdb')
invisible(db_bulk_create(x, "omdb", strs))

## get all docs, writing them to disk
res <- db_alldocs(x, dbname="omdb", disk = (f <- tempfile(fileext=".json")))
res
readLines(res, n = 10)
}
}
