% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.r
\name{check}
\alias{check}
\alias{check.survey}
\title{Check contact survey data}
\usage{
\method{check}{survey}(
  x,
  id.column = "part_id",
  participant.age.column = "part_age",
  country.column = "country",
  year.column = "year",
  contact.age.column = "cnt_age",
  ...
)
}
\arguments{
\item{x}{A \code{\link[=survey]{survey()}} object}

\item{id.column}{the column in both the \code{participants} and \code{contacts} data frames that links contacts to participants}

\item{participant.age.column}{the column in the \code{participants} data frame containing participants' age; if this does not exist, at least columns "..._exact", "..._est_min" and "..._est_max" must (see the \code{estimated.participant.age} option in \code{\link[=contact_matrix]{contact_matrix()}})}

\item{country.column}{the column in the \code{participants} data frame containing the country in which the participant was queried}

\item{year.column}{the column in the \code{participants} data frame containing the year in which the participant was queried}

\item{contact.age.column}{the column in the \code{contacts} data frame containing the age of contacts; if this does not exist, at least columns "..._exact", "..._est_min" and "..._est_max" must (see the \code{estimated.contact.age} option in \code{\link[=contact_matrix]{contact_matrix()}})}

\item{...}{ignored}
}
\value{
invisibly returns a character vector of the relevant columns
}
\description{
Checks that a survey fulfills all the requirements to work with the 'contact_matrix' function
}
\examples{
data(polymod)
check(polymod)
}
