% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_solution.R
\name{prepare_solution}
\alias{prepare_solution}
\title{Prepare Astronomical Solution}
\usage{
prepare_solution(data, quiet = FALSE)
}
\arguments{
\item{data}{A data frame with the following columns:
\itemize{
\item \code{t} Time \eqn{t}{t} (days).
\item \code{ee} Eccentricity \eqn{e} (unitless).
\item \code{lph} Longitude of perihelion \eqn{\varpi} (degrees).
\item \code{lan} Longitude of the ascending node \eqn{\Omega} (degrees).
\item \code{inc} Inclination \eqn{I} (degrees).
}

The easiest way to get this is with \code{\link[=get_solution]{get_solution()}}.}

\item{quiet}{Be quiet?
\itemize{
\item If \code{TRUE}, hide info messages.
\item If \code{FALSE} (the default) print info messages and timing.
}}
}
\value{
A \link[tibble:tibble-package]{tibble} with the new columns added.
}
\description{
Calculates helper columns from an astronomical solution input.
}
\details{
New columns include:
\itemize{
\item \code{lphu} Unwrapped longitude of perihelion \eqn{\varpi} (degrees without
jumps).
\item \code{lanu} Unwrapped longitude of the ascending node \eqn{\Omega} (degrees
without jumps).
\item \code{hh} Variable: \eqn{e\sin(\varpi)}{ee * sin(lph / R2D)}.
\item \code{kk} Variable: \eqn{e\cos(\varpi)}{ee * cos(lph / R2D)}.
\item \code{pp} Variable: \eqn{2\sin(0.5I)\sin(\Omega)}{2 * sin(0.5 * inc / R2D) * n
  R2D)}.
\item \code{qq} Variable: \eqn{2\sin(0.5I)\cos(\Omega)}{2 * sin(0.5 * inc / R2D) *
  n  R2D)}.
\item \code{cc} Helper: \eqn{\cos(I)}{cos(inc / R2D)}.
\item \code{dd} Helper: \eqn{\cos(I)/2}{cos(inc / R2D / 2)}.
\item \code{nnx}, \code{nny}, \code{nnz} The \eqn{x}, \eqn{y}, and \eqn{z}-components of the
Earth's orbit unit normal vector \eqn{\vec{n}}{n}, normal to Earth's
instantaneous orbital plane.
}
}
\seealso{
\code{\link[=get_solution]{get_solution()}}
}
