% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtable_associations.R
\name{gtable_ld_associations}
\alias{gtable_ld_associations}
\title{Gtable of linkage disequilibrium and associations}
\usage{
gtable_ld_associations(
  df_assocs,
  df_ld,
  pvalue_colname = "pvalues",
  labels_colname = "probe_id",
  n_labels = 5,
  diamonds = nrow(df_assocs) <= 40,
  linked_area = diamonds,
  point_size = 150/nrow(df_assocs),
  colors = snp_position_colors(nrow(df_assocs)),
  ...
)
}
\arguments{
\item{df_assocs}{SNP annotation data frame with columns chromosome,
position, and as specified by parameters pvalue_colname
and optionally labels_colname.}

\item{df_ld}{Data frame with columns SNP_A, SNP_B, and R2, as
returned by the snprelate_ld function.}

\item{pvalue_colname}{Column name of df_snp with association values}

\item{labels_colname}{Optional column name of df_snp with labels.
Set NULL to remove labels.}

\item{n_labels}{Number of labels of most associated SNPs to display.}

\item{diamonds}{Should the values be displayed as diamonds or points ?
Default is TRUE for up to 40 SNPs.}

\item{linked_area}{Add a linked area to associations points.
Default same as diamonds.}

\item{point_size}{Point size for ggplot_ld, ignored if diamonds is TRUE.}

\item{colors}{Colors of SNPs}

\item{...}{Passed to ggplot_associations}
}
\value{
gtable
}
\description{
Creates a gtable of a linkage disequilibrium, chromosomic positions, and
association scores ggplots.
}
