% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtable_ld.R
\name{gtable_ld}
\alias{gtable_ld}
\title{Gtable of linkage disequilibrium and chromosomic positions}
\usage{
gtable_ld(
  df_ld,
  df_snp,
  biplot_subset = NULL,
  labels_colname = NULL,
  diamonds = length(unique(df_ld$SNP_A)) < 40,
  point_size = ifelse(is.null(biplot_subset), 120, 80)/sqrt(nrow(df_ld)),
  title = "",
  title_biplot = "",
  ...
)
}
\arguments{
\item{df_ld}{Data frame returned by snprelate_ld}

\item{df_snp}{SNP annotations with columns snpID and position}

\item{biplot_subset}{SNP indexes of the subset for the second ld plot}

\item{labels_colname}{Column name of df_snp to use as SNP labels}

\item{diamonds}{Display the values as diamonds or as points
Default is TRUE for less than 40 SNPs.}

\item{point_size}{Size for geom_point. Ignored if diamonds is TRUE.}

\item{title}{Plot title}

\item{title_biplot}{Optional biplot title}

\item{...}{Passed to ggplot_ld}
}
\value{
gtable of ggplots
}
\description{
Creates a gtable of linkage disequilibrium and chromosomic positions
ggplots. A biplot_subset parameter is available to add a second linkage
disequibrium ggplot to visualize the effect of a SNP selection.
}
\examples{
library(snplinkage)
gds_path <- save_hgdp_as_gds()
gdata <- load_gds_as_genotype_data(gds_path)
qc <- snprelate_qc(gdata, tagsnp = .99)
snp_idxs_8p23 <- select_region_idxs(qc$gdata, chromosome = 8,
  position_min = 11e6, position_max = 12e6)

df_ld <- snprelate_ld(qc$gdata, snps_idx = snp_idxs_8p23, quiet = TRUE)
plt <- gtable_ld(df_ld, df_snp = gdata_snps_annots(qc$gdata))

}
