% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_network.R
\name{random_network}
\alias{random_network}
\title{Construct Artificial Networks}
\usage{
random_network(n, distrib, param = NULL, degree = NULL, take.p = 0.05)
}
\arguments{
\item{n}{the number of nodes in the desired network.}

\item{distrib}{an atomic character representing the desired degree
distribution. User may choose from 11 available distributions: "fixed",
"pois", "ztpois", "geom", "nbinom", "ztgeom", "poly.log", "logarithmic",
"power.law", "full" (fully connected), or "none" (no element connected).}

\item{param}{the distribution parameters. If the function is "fixed",
\code{param} is a vector of degrees.}

\item{degree}{an optional vector of degrees that must be of length \code{n}.
The default is \code{degree = NULL}.}

\item{take.p}{a number between 0 and 1 representing the proportion to take
for elimination with each iteration.}
}
\value{
A list consisting of:
   \item{edges}{The edgelist of the network. A two column
     \code{matrix} where each row is an edge.}
   \item{degree}{The degree sequence of the network, which is
     an \code{integer} vector of length n.}
   \item{degree.left}{A vector of length \code{n} that should be all zeroes.}
   \item{n}{The network order. The order for every network is 2000.}
}
\description{
This function constructs an artificial network from a given distribution.
Only 11 distributions are available.
}
\examples{
a <- random_network(1000, "poly.log", c(2, 13))
}
