% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msn_em.r
\name{snem}
\alias{snem}
\title{EM algorithm for multivariate skew normal distribution.}
\usage{
snem(
  x,
  eps = 0.9,
  iter.eps = 10^-6,
  stop.rule = c("parameter", "log-likelihood")
)
}
\arguments{
\item{x}{A data matrix. Each row is an observation vector.}

\item{eps}{Weight parameter with \eqn{0 \le eps < 1}. Default is 0.9.}

\item{iter.eps}{Convergence threshold. Default is 10^-6.}

\item{stop.rule}{\code{"parameter"}: The difference of the parameter is used as a stopping rule. \code{"log-likelihood"} The difference of the log-likelihood is used as a stopping rule.}
}
\value{
Location parameter (\code{mu}), covariance matrix (\code{omega}), skewness parameter (\code{delta}), and another expression of skewness parameter (\code{lambda}).
}
\description{
EM algorithm in closed form.
}
\details{
The parameter \code{eps} is a tuning parameter which ensures that an initial covariance matrix is positive semi-definite.
}
\examples{
library(sn)
data(ais, package="sn")
x <- ais[c("BMI")]
snem(x, stop.rule ="log-likelihood")
}
\references{
Abe, T., Fujisawa, H., and Kawashima, T. (2019) \emph{EM algorithm using overparametrization for multivariate skew-normal distribution,} \emph{in preparation.}
}
