% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_index.R
\name{sk_sub}
\alias{sk_sub}
\title{Return a sub-grid of a sk grid object}
\usage{
sk_sub(g, ij_keep = NULL, ij_rem = NULL, idx = FALSE, mirror = FALSE)
}
\arguments{
\item{g}{sk grid or any grid-like object accepted by \code{sk}}

\item{ij_keep}{list of grid line numbers ("i" and "j") forming regular sub-grid}

\item{ij_rem}{list of grid line numbers ("i" and "j") whose exclusion forms regular sub-grid}

\item{idx}{logical, if TRUE the function returns a list containing \code{ij_keep} and \code{ij_rem}}

\item{mirror}{logical, whether to mirror the selection in \code{ij_rem} (see details)}
}
\value{
an sk grid object, the requested sub-grid of \code{g}
}
\description{
Creates a "sk" object containing only the grid-lines specified in \code{idx_keep}. Alternatively,
grid lines to remove can be specified in \code{idx_rem}.
}
\details{
One of \code{idx_keep} or \code{idx_rem} (but not both) can be specified, and the grid line numbers
(not intercepts) should be supplied in ascending order in list entries named "i" and "j".

If \code{idx_rem} is specified, \code{mirror=TRUE} will cause the selection in \code{idx_rem} to be
reflected about the central grid line (useful for specifying outer grid lines). \code{mirror}
is ignored if \code{idx_keep} is specified instead.

Default \code{idx=FALSE} causes the function to return the sub-grid as a sk grid object.
If \code{idx=TRUE}, the function instead returns a list containing \code{idx_keep} and \code{idx_rem} as
specified above.

If neither \code{idx_keep} nor \code{idx_rem} is supplied, the function removes outer grid lines
iteratively (selecting the one with highest proportion of \code{NA}s), attempting to find a
complete sub-grid (having no \code{NA}s) somewhere in the interior. This heuristic is designed
for rasters with few \code{NA}s, all located around the perimeter.
}
\examples{

# make an example grid
g = sk(c(50, 100))
g[] = apply(expand.grid(g[['gyx']]), 1, \(z) cos( 2*sum(z^2) ) )
plot(g)

# subset by specifying grid lines to keep
ij_keep = list(i=seq(1, 50, by=2), j=seq(1, 50, by=2))
g_keep = sk_sub(g, ij_keep)
plot(g_keep)

# get the indices kept and removed
idx = sk_sub(g, ij_keep, idx=TRUE)

# equivalent call specifying grid lines to omit
g_rem = sk_sub(g, ij_rem=idx[['rem']])
identical(g_rem, g_keep)

# remove some data around the edges of the grid
idx = sk_sub(g, ij_rem=list(i=seq(10), j=seq(10)), mirror=TRUE, idx=TRUE)
idx_y_pts = sk_sub_idx(dim(g), idx[['rem']]['i'], idx=TRUE)
idx_x_pts = sk_sub_idx(dim(g), idx[['rem']]['j'], idx=TRUE)
idx_pts = c(idx_y_pts, idx_x_pts)
idx_na = sort(sample(idx_pts, 0.6*length(idx_pts)))
g[idx_na] = NA
plot(g)

# identify the interior sub-grid that is complete
g_sub = sk_sub(g)
print(g_sub)
plot(g_sub)

# verify it is as large as expected
( dim(g) - dim(g_sub) ) == sapply(idx[['rem']], length)

}
\seealso{
Other sk constructors: 
\code{\link{sk_rescale}()},
\code{\link{sk_snap}()},
\code{\link{sk}()}
}
\concept{sk constructors}
\keyword{internal}
