% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_var.R
\name{sk_corr_mat}
\alias{sk_corr_mat}
\title{Construct 1D stationary correlation matrices for regularly spaced data}
\usage{
sk_corr_mat(pars, n, gres = 1, i = seq(n), j = seq(n))
}
\arguments{
\item{pars}{list of kernel parameters 'k' and 'kp' (see \code{sk_corr})}

\item{n}{positive integer, the number of points on the 1D line}

\item{gres}{positive numeric, the distance between adjacent grid lines}

\item{i}{vector, a subset of \code{seq(n)} indicating rows to return}

\item{j}{vector, a subset of \code{seq(n)} indicating columns to return}
}
\value{
the n x n correlation matrix, or its subset as specified in \code{i}, \code{j}
}
\description{
The i,jth value of the returned correlation matrix is the marginal correlation between
the ith and jth points in a regularly spaced sequence of \code{n} 1-dimensional (1D) points,
given the correlation model with parameters defined in list \code{pars}.
}
\details{
This matrix is symmetric and Toeplitz as a result of the assumption of stationarity
of the random field and regularity of the grid.

The distance between adjacent points is specified by \code{gres}. Subsets of
the correlation matrix can be requested by specifying \code{i} and/or \code{j} (default
behaviour is to include all).

Like \code{sk_corr}, this function is for computing 1D components of a 2D process.
The product of two matrices returned by \code{sk_corr_mat} is the correlation
matrix for a spatially separable process (see examples).
}
\examples{

# define test distances, grid, and example kernel
n_test = 10
g_example = sk(n_test)
pars = sk_pars(g_example, c('mat', 'gau'))

# compute the correlation matrices and their kronecker product
cx = sk_corr_mat(pars[['x']], n=n_test)
cy = sk_corr_mat(pars[['y']], n=n_test)
cxy = kronecker(cx, cy)

# sk_var can return these two matrices in a list
cxy_list = sk_var(g_example, pars, sep=TRUE)
max(abs( cxy_list[['y']] - cy ))
max(abs( cxy_list[['x']] - cx ))

# ... or it can compute the full covariance matrix for model pars (default)
var_matrix = sk_var(g_example, pars, sep=FALSE)
var_matrix_compare = (pars$psill*cxy) + diag(pars$eps, n_test^2)
max(abs( var_matrix - var_matrix_compare ))

# extract a subgrid without computing the whole thing
cx_sub = sk_corr_mat(pars[['x']], n=n_test, i=2:4, j=2:4)
cx_sub - cx[2:4, 2:4]

# gres scales distances. Increasing gres causes correlations to decrease
cx_long = sk_corr_mat(pars[['x']], n=n_test, gres=2*g_example$gres)
cx_long < cx

}
\seealso{
Other internal variance-related functions: 
\code{\link{sk_corr}()},
\code{\link{sk_toep_mult}()},
\code{\link{sk_var_mult}()}
}
\concept{internal variance-related functions}
\keyword{internal}
