% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_sample.R
\name{sk_add_bins}
\alias{sk_add_bins}
\title{Add bin labels to a variogram data frame}
\usage{
sk_add_bins(vg, n_bin = 25, probs = NULL)
}
\arguments{
\item{vg}{data frame with numeric column 'd'}

\item{n_bin}{integer number of distance bins to assign}

\item{probs}{numeric vector of quantile probabilities to establish breakpoints (length \code{n_bin+1})}
}
\value{
same as input \code{vg} but with integer column \code{bin} added/modified
}
\description{
Helper function for grouping the rows of input data frame \code{vg} into \code{n_bins} bins
according to the value of the (numeric) distance column \code{d}. This uses either \code{base::cut}
or, if \code{probs} is supplied, \code{stats::quantile}.
}
\details{
By default, the function sets \code{probs} to a sequence of length \code{1+n_bin} evenly splitting
the interval [0,1] to ensure approximately equal sample sizes for each bin. Setting
\code{probs=NA} instead sets the bin endpoints such that the range of distances is split
evenly (note this may produce empty bins)

The function is called by \code{sk_sample_vg} and \code{sk_plot_semi} (when column \code{bin} is
missing). It can also be used to recompute bins after an \code{rbind} of multiple variogram
data frames.
}
\examples{
distance_df = data.frame(d=runif(25))
sk_add_bins(distance_df)

# specify fewer bins and set up quantiles explicitly
sk_add_bins(distance_df, n_bin = 5) # same as ...
sk_add_bins(distance_df, n_bin = 5, probs=seq(0, 1, length.out=6))

# break range of distances into evenly spaced bins (of varying sample sizes)
sk_add_bins(distance_df, n_bin = 5, probs=NULL)

}
\seealso{
Other variogram functions: 
\code{\link{sk_vario_fun}()}
}
\concept{variogram functions}
\keyword{internal}
