% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sms.R
\name{find_best_selection}
\alias{find_best_selection}
\title{find_best_selection}
\usage{
find_best_selection(area, insms, inseed = -1)
}
\arguments{
\item{area}{A census area}

\item{insms}{A microsimulation object which holds the data and details of 
the simulation such as iterations, lexicon.}

\item{inseed}{test}
}
\value{
list A list with results (#areaid, #selection, #tae, #tries, #error_states).
}
\description{
Find the best selection of individual records for a census area.
}
\details{
Calculate the best area representation, after a series of selection tries.
}
\examples{
library(sms)
data(survey) #load the data
data(census)
in.lexicon=createLexicon() # Create a data lexicon for holding the associated column names.
in.lexicon=addDataAssociation(in.lexicon, c("he","he"))
in.lexicon=addDataAssociation(in.lexicon, c("females","female"))

this_area=as.data.frame(census[1,]) #Select the first area from the census table
insms= new("microsimulation",census=census,panel=survey, lexicon=in.lexicon, iterations=10)
best=find_best_selection(this_area, insms)
print(best)
}
\author{
Dimitris Kavroudakis \email{dimitris123@gmail.com}
}

