% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_violin.R
\name{sm_violin}
\alias{sm_violin}
\title{Violin Plot with Jittered Individual Points}
\usage{
sm_violin(
  ...,
  violin.params = list(fill = "gray90", color = "transparent"),
  err.params = list(size = 1.2, linewidth = 1.2),
  point.params = list(alpha = 0.25, size = 2),
  errorbar_type = "sd",
  point_jitter_width = 0.17,
  points = TRUE,
  borders = TRUE,
  legends = FALSE,
  seed = NULL,
  forget = FALSE
)
}
\arguments{
\item{...}{Additional aesthetic parameters applied across points, the violin plot, and error bars. Optional.}

\item{violin.params}{A list of parameters for customizing the violin plot. Common parameters include:
\itemize{
  \item \code{fill}: Fill color of the violin plot.
  \item \code{color}: Outline color of the violin plot.
  \item \code{alpha}: Transparency level of the violin plot.
}
Default: \code{list(fill = 'gray90', color = 'transparent')}.}

\item{err.params}{A list of parameters for customizing the error bars. Common parameters include:
\itemize{
  \item \code{size}: Size of the error bar endpoints.
  \item \code{linewidth}: Width of the error bar lines.
  \item \code{color}: Color of the error bars.
}
Default: \code{list(size = 1.2, linewidth = 1.2)}.}

\item{point.params}{A list of parameters for customizing individual points. Common parameters include:
\itemize{
  \item \code{alpha}: Transparency level of the points.
  \item \code{size}: Size of the points.
  \item \code{shape}: Shape of the points.
}
Default: \code{list(alpha = 0.25, size = 2)}.}

\item{errorbar_type}{A string specifying the type of error bars to display:
\itemize{
  \item \code{'se'}: Standard error.
  \item \code{'sd'}: Standard deviation (default).
  \item \code{'ci'}: 95% confidence interval.
}}

\item{point_jitter_width}{A numeric value specifying the degree of horizontal jitter applied to individual points.
\itemize{
  \item If set to \code{0}, points are aligned along the y-axis without jitter.
  \item Default: \code{0.17}.
}}

\item{points}{Logical. Determines whether individual points are displayed:
\itemize{
  \item \code{TRUE}: Display points (default).
  \item \code{FALSE}: Hide points.
}}

\item{borders}{Logical. Determines whether grid borders are displayed:
\itemize{
  \item \code{TRUE}: Display borders (default).
  \item \code{FALSE}: Remove borders.
}}

\item{legends}{Logical. Determines whether legends are displayed:
\itemize{
  \item \code{TRUE}: Display legends.
  \item \code{FALSE}: Hide legends (default).
}}

\item{seed}{A numeric value to set a random seed for reproducible jittered points.
Default: \code{NULL} (no seed).}

\item{forget}{Logical. Determines whether to apply the default aesthetic parameters:
\itemize{
  \item \code{TRUE}: Ignore default aesthetic parameters (\code{violin.params},
        \code{err.params}, and \code{point.params}) and apply only user-supplied customizations.
  \item \code{FALSE}: Merge user-supplied customizations with the defaults (default).
}}
}
\value{
A ggplot2 object containing a violin plot with optional jittered points and error bars.
}
\description{
Generates a violin plot with optional jittered individual points and error bars.
This function allows for flexible customization of the violin, points, and error bars,
and supports displaying standard deviation, standard error, or confidence intervals as error bars.
}
\examples{
library(ggplot2)
library(smplot2)
set.seed(1) # generate random data
day1 = rnorm(16,2,1)
day2 = rnorm(16,5,1)
Subject <- rep(paste0('S',seq(1:16)), 2)
Data <- data.frame(Value = matrix(c(day1,day2),ncol=1))
Day <- rep(c('Day 1', 'Day 2'), each = length(day1))
df <- cbind(Subject, Data, Day)
# with aesthetic defaults of smplot
ggplot(data = df, mapping = aes(x = Day, y = Value, color = Day)) +
sm_violin() +
scale_color_manual(values = sm_color('blue','orange'))

# without aesthetic defaults of smplot
ggplot(data = df, mapping = aes(x = Day, y = Value, color = Day)) +
sm_violin(violin.params = list()) +
scale_color_manual(values = sm_color('blue','orange'))


}
