% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_credentials.R
\name{set_credentials}
\alias{set_credentials}
\title{Set credentials to access Barcelona Expert Center (BEC) server}
\usage{
set_credentials(username, password)
}
\arguments{
\item{username}{a character string containing BEC server username.}

\item{password}{a character string containing BEC server password.}
}
\value{
a character string with the inputs pasted together in the format
required by \code{\link[=find_smos]{find_smos()}} and
\code{\link[=download_smos]{download_smos()}}.
}
\description{
To use some functionalities of \code{smosr} package (e.g. access the server
or download data to a local computer), the user should first register at
Barcelona Expert Center (BEC) webpage. This function allows the authenticated
users to set their BEC credentials (username and password) for the current R
session which are used internally in \code{\link[=find_smos]{find_smos()}}
and \code{\link[=download_smos]{download_smos()}}.
}
\details{
If you do not have your BEC login details yet, please register on
https://bec.icm.csic.es/bec-ftp-service-registration/.
}
\examples{
\dontrun{
set_credentials("username", "password")
}

}
