\name{dhuber}
\alias{dhuber}
\alias{edhuber}
\alias{rhuber}
\title{Huber's least favourable distribution}
\description{
  Density for and random values from Huber's least favourable
  distribution, see Huber and Ronchetti (2009).
}
\usage{
  dhuber(x, k=0.862, mu=0, sigma=1)
  edhuber(x, k=0.862, mu=0, sigma=1)
  rhuber(n,k=0.862, mu=0, sigma=1)
}
\arguments{
  \item{x}{numeric vector.}
  \item{k}{numeric. Borderline value of central Gaussian part of the
    distribution. The default values refers to a 20\% contamination
    neighborhood of the Gaussian distribution.
  }
  \item{mu}{numeric. distribution mean.}
  \item{sigma}{numeric. Distribution scale (\code{sigma=1} defines the
    distribution in standard form, with standard Gaussian centre).}
  \item{n}{integer. Number of random values to be generated.}

}
\details{
  \describe{
    \item{dhuber:}{density.}
    \item{edhuber:}{density, and computes the contamination proportion
      corresponding to \code{k}.}
    \item{rhuber:}{random number generation.}
  }
}

\value{
  \code{dhuber} gives out a vector of density values.

  \code{edhuber} gives out a list with components \code{val} (density
  values) and \code{eps} (contamination proportion).

  \code{rhuber} gives out a vector of random numbers generated by
  Huber's least favourable distribution.
}
\references{
  Huber, P. J. and Ronchetti, E. (2009) Robust Statistics (2nd
  ed.). Wiley, New York.
}
\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche/}
}
\examples{
  set.seed(123456)
  edhuber(1:5,k=1.5)
  rhuber(5)
} 
\keyword{distribution}

