% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smfishHmrf.hmrfem.R
\name{smfishHmrf.generate.centroid}
\alias{smfishHmrf.generate.centroid}
\title{Generate cluster centroids, where input is given as a matrix.}
\usage{
smfishHmrf.generate.centroid(y, par_k, par_seed = -1, nstart)
}
\arguments{
\item{y}{expression matrix}

\item{par_k}{number of clusters}

\item{par_seed}{random generator seed (to fix it set it to above 0, or -1 if no fixing). Change the par_seed to vary the initialization.}

\item{nstart}{number of starts (kmeans parameter). It is recommended to set nstart to at least 100 (preferrably 1000).}
}
\value{
A kmeans list with centers and cluster fields
}
\description{
This function assumes that the input gene expression matrix file has been already loaded into a matrix. The function accepts a matrix and applies kmeans clustering to generate cluster centroids.
}
\examples{
data(seqfishplus)
kk<-smfishHmrf.generate.centroid(seqfishplus$y, par_k=9, par_seed=100, nstart=100)
}
