% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast.sim.R
\name{fast.sim}
\alias{fast.sim}
\title{Perform \code{fast.test} on simulated data}
\usage{
fast.sim(nsim = 1, ty, ex, pop, ubpop, type = "poisson", cl = NULL)
}
\arguments{
\item{nsim}{A positive integer indicating the number of
simulations to perform.}

\item{ty}{The total number of cases in the study area.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{pop}{The population size associated with each
region.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}
}
\value{
A vector with the maximum test statistic for each
  simulated data set.
}
\description{
\code{fast.sim} efficiently performs
\code{\link{fast.test}} on a simulated data set.  The
function is meant to be used internally by the
\code{\link{fast.test}} function, but is informative for
better understanding the implementation of the test.
}
\examples{
data(nydf)
coords <- with(nydf, cbind(longitude, latitude))
cases <- floor(nydf$cases)
pop <- nydf$pop
ty <- sum(cases)
ex <- ty / sum(pop) * pop
tsim <- fast.sim(1, ty, ex, pop = pop, ubpop = 0.5)
}
