% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters-method.R
\name{clusters}
\alias{clusters}
\title{Extract clusters}
\usage{
clusters(x, idx = seq_along(x$clusters), ...)
}
\arguments{
\item{x}{An object with clusters.}

\item{idx}{An index vector indicating the elements of
\code{x$clusters} to print information for. The default
is all clusters.}

\item{...}{Currently unimplemented}
}
\description{
\code{clusters} extracts the clusters contained in \code{x}.
}
\examples{
data(nydf)
coords <- with(nydf, cbind(longitude, latitude))
out <- scan.test(
  coords = coords, cases = floor(nydf$cases),
  pop = nydf$pop, nsim = 19,
  alpha = 0.2, longlat = TRUE
)
clusters(out)
clusters(out, idx = 1:2)
}
\author{
Joshua French
}
