% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_delete_rows.R
\name{ss_delete_rows}
\alias{ss_delete_rows}
\title{Delete rows from a given sheet}
\usage{
ss_delete_rows(ss_id, row_ids = NULL)
}
\arguments{
\item{ss_id}{The sheetId, permalink, or name of the Smartsheet sheet to read}

\item{row_ids}{A vector of the smartsheet rowIds, or NULL to delete all}
}
\value{
A list of ss_resp objects
}
\description{
Delete rows from a given sheet
}
\examples{
\dontrun{
df = data.frame(PK=c(1,2), FK=c("a","b"))
ss_id = ss_sheetid(ss_write_sheet(paste0("smartsheetr-example-",random_sheet_name()), data=df))
row_ids = ss_row_ids(ss_id)
ss_delete_rows(ss_id, row_ids[2])
ss_read_sheet(ss_id)
# clean up
ss_delete_sheet(ss_id)
}

}
