% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssp_chakraborti.R
\name{n_locshift_bound}
\alias{n_locshift_bound}
\title{Compute an upper bound the sample size based on two pilot samples.}
\usage{
n_locshift_bound(
  s1,
  s2,
  delta,
  alpha = 0.05,
  power = 0.9,
  quantile = 0.9,
  n_resamples = 500,
  q = 0.5
)
}
\arguments{
\item{s1, s2}{Pilot samples}

\item{delta}{numeric value, location shift parameter \eqn{\delta}}

\item{alpha}{Type I error probability}

\item{power}{1 - Type II error probability, the desired statistical
power}

\item{quantile}{Quantile to use as the upper bound.}

\item{n_resamples}{number of resamples to use in bootstrapping}

\item{q}{size of group0 relative to total sample size.}
}
\value{
Returns an object of class \code{"sample_size"}. It contains
the following components:
\item{n}{the total sample size}
\item{n0}{sample size in Group 0 (control group)}
\item{n1}{sample size in Group 1 (treatment group)}
\item{two_sided}{logical, \code{TRUE}, if the estimated sample size
refers to a two-sided test}
\item{alpha}{type I error rate used in sample size estimation}
\item{power}{target power used in sample size estimation}
\item{effect}{effect size used in sample size estimation}
\item{effect_type}{short description of the type of effect size}
\item{comment}{additional comment, if there is any}
\item{call}{the matched call.}
}
\description{
Based on the procedure described by Chakraborti, Hong, & van de Wiel (2006)
}
\details{
WARNING: Note that the underlying estimation has high variability due
to its dependence on pilot samples. The smaller the pilot sample,
the more uncertain is
the estimation of the required sample size. In a simulation study, we
found that the underlying method may also be inaccurate on average, depending on
the investigated data.
}
\examples{
\dontrun{
n_locshift_bound(s1 = rexp(10), s2 = rexp(10),
           delta = 0.35, alpha = 0.05, power = 0.9, n_resamples = 5)}
}
\references{
Chakraborti, S., Hong, B., & van de Wiel, M. A. (2006). A note on
sample size determination for a nonparametric test of location.
Technometrics, 48(1), 88–94. https://doi.org/10.1198/004017005000000193
}
