% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot_unused_files.R
\name{spot_unused_files}
\alias{spot_unused_files}
\title{Spot/remove unused files}
\usage{
spot_unused_files(
  path = ".",
  file.extensions = c("png", "jpg", "jpeg", "gif", "bmp", "tiff", "tif", "csv", "xls",
    "xlsx", "txt"),
  script.extensions = c("R", "Rmd", "qmd"),
  archive = FALSE,
  ignore.folder = "./docs"
)
}
\arguments{
\item{path}{A character string with the path to the directory to be analyzed. Default is current directory.}

\item{file.extensions}{A character vector with the file extensions to be considered. Default is c("png", "jpg", "jpeg", "gif", "bmp", "tiff", "tif", "csv", "xls", "xlsx", "txt").}

\item{script.extensions}{A character vector with the script extensions to be considered. Default is c("R", "Rmd", "qmd").}

\item{archive}{A logical value indicating whether to archive the unused files. If \code{TRUE} the spotted files will be move into the folder "./unused_files". Default is \code{FALSE}.}

\item{ignore.folder}{A character string with the path or paths to the directory(ies) to be ignored. Default is "./docs".}
}
\value{
Returns a data frame with 2 columns: file.name (self explanatory) and folder (where the file is found).
}
\description{
\code{spot_unused_files}
}
\details{
This function is used to spot/remove unused files in a project directory. It is useful to keep the project directory clean and organized. It is recommended to first run the function with a the argument \code{archive = FALSE} to spot which files are being spotted and then run \code{archive = TRUE} if they need to be removed.
}
\examples{
{
}

}
\references{
{
Araya-Salas, M., Arriaga, A. (2023), sketchy: research compendiums for data analysis in R. R package version 1.0.3.
}
}
\seealso{
\code{\link{add_to_gitignore}}, \code{\link{make_compendium}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
