% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{kin2degree}
\alias{kin2degree}
\title{Kinship coefficient to degree}
\usage{
kin2degree(k, max_degree = 3L)
}
\arguments{
\item{k}{Kinship coefficient (numeric, typically between 0 and .5, although KING can produce values <0).}

\item{max_degree}{Max degree resolution (default 3). Used to seed
\link[=dibble]{dibble}. Anything below the inference range of
\code{max_degree} will report \code{NA}. See \link[=dibble]{dibble}.}
}
\value{
A vector with inferred degree, up to the maximum degree in \code{dibble} (anything more distant is \code{NA}, i.e., unrelated).
}
\description{
Infers relationship degree given a kinship coefficient.
}
\examples{
kin2degree(0.5)
kin2degree(0.25)
kin2degree(0.125)
kin2degree(0.0625)
kin2degree(0.03125)
kin2degree(0.03125, max_degree=5)
kin2degree(-0.05)
k <- seq(.02, .5, .03)
kin2degree(k)
kin2degree(k, max_degree=5)
tibble::tibble(k=k) \%>\% dplyr::mutate(degree=kin2degree(k))

}
