% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shorten_string.R
\name{shorten_string}
\alias{shorten_string}
\title{Shorten character strings}
\usage{
shorten_string(s, max.length = NULL, abbr = "...")
}
\arguments{
\item{s}{A string.}

\item{max.length}{Maximum length of chars for the string.}

\item{abbr}{String that will be used as suffix, if \code{s} was shortened.}
}
\value{
A shortened string.
}
\description{
This function shortens strings that are longer than \code{max.length}
   chars, without cropping words.
}
\details{
If the string length defined in \code{max.length} happens to be inside
  a word, this word is removed from the returned string (see 'Examples'), so
  the returned string has a \emph{maximum length} of \code{max.length}, but
  might be shorter.
}
\examples{
s <- "This can be considered as very long string!"

# string is shorter than max.length, so returned as is
shorten_string(s, 60)

# string is shortened to as many words that result in
# a string of maximum 20 chars
shorten_string(s, 20)

# string including "considered" is exactly of length 22 chars
shorten_string(s, 22)

}
