% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets_manager.R
\name{aws_secrets_create}
\alias{aws_secrets_create}
\title{Create a secret}
\usage{
aws_secrets_create(name, secret, description = NULL, ...)
}
\arguments{
\item{name}{(character) The name of the new secret. required}

\item{secret}{(character/raw) The text or raw data to encrypt and store
in this new version of the secret. AWS recommends for text to use a JSON
structure of key/value pairs for your secret value (see examples below).
required}

\item{description}{(character) The description of the secret. optional}

\item{...}{further named parameters passed on to \code{create_secret}
\url{https://www.paws-r-sdk.com/docs/secretsmanager_create_secret/}}
}
\value{
(list) with fields:
\itemize{
\item ARN
\item Name
\item VersionId
\item ReplicationStatus
}
}
\description{
This function does not create your database username and/or password.
Instead, it creates a "secret", which is typically a combination
of credentials (username + password + other metadata)
}
\details{
Note that we autogenerate a random UUID to pass to the
\code{ClientRequestToken} parameter of the \code{paws} function \code{create_secret}
used internally in this function.

This function creates a new secret. See \code{\link[=aws_secrets_update]{aws_secrets_update()}} to
update an existing secret. This function fails if you call it with
an existing secret with the same name or ARN
}
\examples{
\dontshow{if (aws_has_creds() && interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
try({
# Text secret
secret1 <- random_string("secret-", size = 16)
aws_secrets_create(
  name = secret1,
  secret = '{"username":"david","password":"EXAMPLE-PASSWORD"}',
  description = "My test database secret as a string"
)
aws_secrets_get(secret1)$SecretString

# Raw secret
secret2 <- random_string("secret-", size = 16)
aws_secrets_create(
  name = secret2,
  secret = charToRaw('{"username":"david","password":"EXAMPLE-PASSWORD"}'),
  description = "My test database secret as raw"
)
aws_secrets_get(secret2)$SecretBinary

# Cleanup
aws_secrets_delete(secret1, ForceDeleteWithoutRecovery = TRUE)
aws_secrets_delete(secret2, ForceDeleteWithoutRecovery = TRUE)
})
\dontshow{\}) # examplesIf}
}
