% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{aws_group}
\alias{aws_group}
\title{Get a group}
\usage{
aws_group(name)
}
\arguments{
\item{name}{(character) the group name}
}
\value{
a named list with slots for:
\itemize{
\item group: information about the group (tibble)
\item users: users in the group (tibble)
\item policies (character)
\item attached_policies (tibble)
}
}
\description{
Get a group
}
\details{
see docs \url{https://www.paws-r-sdk.com/docs/iam_get_group/}
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a group
aws_group_create("testing")
# get the group
aws_group(name = "testing")
# cleanup
aws_group_delete(name = "testing")
\dontshow{\}) # examplesIf}
}
\seealso{
Other groups: 
\code{\link{aws_group_create}()},
\code{\link{aws_group_delete}()},
\code{\link{aws_group_exists}()},
\code{\link{aws_groups}()},
\code{\link{six_group_delete}()}
}
\concept{groups}
