% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{aws_file_download}
\alias{aws_file_download}
\title{Download a file}
\usage{
aws_file_download(remote_path, path, ...)
}
\arguments{
\item{remote_path}{(character) one or more remote S3 paths. required}

\item{path}{(character) one or more file paths to write to. required}

\item{...}{named parameters passed on to \code{\link[s3fs:download]{s3fs::s3_file_download()}}}
}
\value{
(character) a vector of local file paths
}
\description{
Download a file
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(glue)

# single file
bucket1 <- random_bucket()
aws_bucket_create(bucket1)
tfile1 <- tempfile()
remote1 <- s3_path(bucket1, glue("{basename(tfile1)}.txt"))
cat("Hello World!\n", file = tfile1)
aws_file_upload(path = tfile1, remote_path = remote1)
dfile <- tempfile()
aws_file_download(remote_path = remote1, path = dfile)
readLines(dfile)

# many files
bucket2 <- random_bucket()
aws_bucket_create(bucket2)
tfiles <- replicate(n = 3, tempfile())
for (file in tfiles) cat("Hello mars!!!!!!\n", file = file)
for (file in tfiles) print(readLines(file))
for (file in tfiles) {
  aws_file_upload(file, s3_path(bucket2, glue("{basename(file)}.txt")))
}
downloadedfiles <- replicate(n = 3, tempfile())
for (file in downloadedfiles) print(file.exists(file))
remotes2 <- s3_path(bucket2, glue("{basename(tfiles)}.txt"))
aws_file_download(remote_path = remotes2, path = downloadedfiles)
for (file in downloadedfiles) print(readLines(file))

# Cleanup
six_bucket_delete(bucket1, force = TRUE)
six_bucket_delete(bucket2, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other files: 
\code{\link{aws_file_attr}()},
\code{\link{aws_file_copy}()},
\code{\link{aws_file_delete}()},
\code{\link{aws_file_exists}()},
\code{\link{aws_file_rename}()},
\code{\link{aws_file_upload}()},
\code{\link{six_file_upload}()}
}
\concept{files}
